/* @(#) 2.4 src/somd/somd.h, som, som2.0.fix 1/19/94 17:25:07 [5/15/94 17:54:00] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */


/*
 *  somd.h - global include file for DSOM definitions
 */

#ifndef somd_h
#define somd_h

/*  --- base SOM and DSOM types ---  */

#include <som.h>
/*  when som.h includes somport.h, delete the following define */
#ifdef _WIN16
#define SIZET_CAST (size_t)
#else
#define SIZET_CAST
#endif

#ifndef _WIN16
#define W16LOADDS
#endif

#include <somtcnst.h>
#include <somir.h>

#include <somdtype.h>

/*  --- DSOM error codes ---  */

#include <somderr.h>

/*  --- DSOM externals ---  */

#include <somdext.h>

/*  --- DSOM global variables ---
 *
 *  Several global variables point to DSOM objects that are always or often
 *  used by DSOM applications.
 *
 *  SOMD_ObjectMgr, SOMD_ORBObject, and SOMD_ImplRepObject are initialized
 *  by SOMD_Init().
 *
 *  SOMD_ImplDefObject is initially NULL.   DSOM servers *MUST* set this to
 *  an ImplementationDef object which describes the server implementation.
 *  DSOM clients *MUST* leave this variable NULL.
 *
 *  SOMD_SOMOAObject is initially NULL.  DSOM servers should use the SOM
 *  Object Adapter can use this variable to refer to the instantiated SOMOA.
 *  It is not used by client processes.
 *
 *  The external references to these global variables are defined in the
 *  .h files for their respective classes.
 */

#include <somdom.h>		/* SOMD_ObjectMgr (incl. SOMDServer) */
#include <orb.h>		/* SOMD_ORBObject */
#include <implrep.h>		/* SOMD_ImplRepObject */
#include <impldef.h>		/* SOMD_ImplDefObject */
#include <somoa.h>		/* SOMD_SOMOAObject */

/*  --- DSOM interfaces ---
 *
 *  Include the interfaces for other commonly used DSOM classes.
 */

#include <somdobj.h>		/* SOMDObject */
#include <somdcprx.h>		/* SOMDClientProxy */
#include <cntxt.h>		/* Context */
#include <nvlist.h>		/* NVList */
#include <request.h>		/* Request */
#include <stexcep.h>		/* standard exceptions */
#include <principl.h>		/* Principal object */

#endif /* somd_h */
